% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov-blanket.R
\name{mb}
\alias{mb}
\title{Compute the Markov blanket}
\usage{
mb(dag, node, data.dists = NULL)
}
\arguments{
\item{dag}{a matrix or a formula statement (see details for format) defining the network structure, a directed acyclic graph (DAG).}

\item{node}{a character vector of the nodes for which the Markov Blanket should be returned.}

\item{data.dists}{a named list giving the distribution for each node in the network, see details.}
}
\value{
character vector of node names from the Markov blanket.
}
\description{
This function computes the Markov blanket of a set of nodes given a DAG (Directed Acyclic Graph).
}
\details{
This function returns the Markov Blanket of a set of nodes given a DAG.

The \code{dag} can be provided using a formula statement (similar to glm). A typical formula is \code{ ~ node1|parent1:parent2 + node2:node3|parent3}. The formula statement have to start with \code{~}. In this example, node1 has two parents (parent1 and parent2). node2 and node3 have the same parent3. The parents names have to exactly match those given in \code{name}. \code{:} is the separtor between either children or parents, \code{|} separates children (left side) and parents (right side), \code{+} separates terms, \code{.} replaces all the variables in \code{name}.
}
\examples{
## Defining distribution and dag
dist <- list(a="gaussian", b="gaussian", c="gaussian", d="gaussian",
             e="binomial", f="binomial")
dag <- matrix(c(0,1,1,0,1,0,
                0,0,1,1,0,1,
                0,0,0,0,0,0,
                0,0,0,0,0,0,
                0,0,0,0,0,1,
                0,0,0,0,0,0), nrow = 6L, ncol = 6L, byrow = TRUE)
colnames(dag) <- rownames(dag) <- names(dist)

mb(dag, node = "b")
mb(dag, node = c("b","e"))

mb(~a|b:c:e+b|c:d:f+e|f, node = "e", data.dists = dist)
}
\keyword{utilities}
