% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnj.R
\name{extract_parts}
\alias{extract_parts}
\title{Extract different parts from lawsuit ID}
\usage{
extract_parts(id, parts = "")
}
\arguments{
\item{id}{One or more lawsuit IDs}

\item{parts}{String or string vector with desired parts (see \strong{description})}
}
\description{
Given one or more lawsuit IDs, this function extracts one or more
parts of the IDs given the following correspondence:
\itemize{
\item "N": number
\item "D": verification digits
\item "A": year
\item "J": segment
\item "T": court
\item "O": origin
\item "": all of the above
}
}
\examples{
\dontrun{
  extract_parts("001040620018260004", "N")
  extract_parts("001040620018260004", c("N", "A", "O"))
}
}
