% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCorSites.R
\name{getCorSites}
\alias{getCorSites}
\title{Get correlated sites with substitutions}
\usage{
getCorSites(fileLoc, corMethod = "mcbasc")
}
\arguments{
\item{fileLoc}{exact location of multiple sequence alignment file in "FASTA" format}

\item{corMethod}{One of the methods to compute correlated sites viz. 'mip', 'elsc', 'mcbasc' and 'omes'. Default is 'mcbasc'.}
}
\value{
A subset alignment matrix of original multiple sequence alignment with significant correlations.
}
\description{
Get correlated sites with substitutions
}
\examples{
file = system.file("extdata", "linB_toy_ali.fasta", package = "aaSEA")
getCorSites(fileLoc = file,corMethod="mcbasc")
}
