% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_mosaic.R
\name{canvas_mosaic}
\alias{canvas_mosaic}
\title{Draw Moisaics}
\usage{
canvas_mosaic(colors, n = 1000, resolution = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{n}{a positive integer specifying the number of random data points to generate.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws the predictions from a k-nearest neighbors algorithm trained on randomly generated categorical data.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_mosaic(colors = colorPalette("retro2"))
}

}
\references{
\url{https://en.wikipedia.org/wiki/K-nearest_neighbors_algorithm}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
