% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAI.R
\docType{methods}
\name{DAI}
\alias{DAI}
\alias{DAI,aRchi-method}
\title{Estimate the index of dominance of the principal axis: DAI.}
\usage{
DAI(aRchi)

\S4method{DAI}{aRchi}(aRchi)
}
\arguments{
\item{aRchi}{an object of class aRchi with at least the QSM and the Paths table}
}
\value{
Numeric. The value of DAI.
}
\description{
Estimate the index of dominance of the principal axis (DAI) from an aRchi object.
}
\details{
The idea of DAI is to disentangle architectures of trees with a strong apical dominance, i.e. with a central main stem growing more strongly than other side axes (such as in most conifers, for instance), from those having a spread out branching pattern with similar axes and no obvious main stem.

The higher the index the more dominant the principal axis. DAI is computed based on the indices A0 which is an index of the probability of being the principal axis for each path of the tree (see function \code{\link{Compute_A0}}).
More information are given in Martin-Ducup et al 2020
}
\examples{
# Read an aRchi file with at least the QSM and the paths table
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)

DAI(Tree1_aRchi)

}
\references{
Martin-Ducup, O. et al. Terrestrial laser scanning reveals convergence of tree architecture with increasingly dominant crown canopy position. Functional Ecology (2020).
}
\seealso{
\code{\link{Compute_A0}} to identify the principal axis (i.e \code{max(A0)}).
}
