% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-ivreg.R
\docType{class}
\name{Zelig-ivreg-class}
\alias{Zelig-ivreg-class}
\alias{zivreg}
\title{Instrumental-Variable Regression}
\source{
\code{ivreg} is from Christian Kleiber and Achim Zeileis (2008). Applied
Econometrics with R. New York: Springer-Verlag. ISBN 978-0-387-77316-2. URL
\url{https://CRAN.R-project.org/package=AER}
}
\arguments{
\item{formula}{specification(s) of the regression relationship}

\item{instruments}{the instruments. Either \code{instruments} is missing and
formula has three parts as in \code{y ~ x1 + x2 | z1 + z2 + z3} (recommended) or
formula is \code{y ~ x1 + x2} and instruments is a one-sided formula
\code{~ z1 + z2 + z3}. Using \code{instruments} is not recommended with \code{zelig}.}

\item{model, x, y}{logicals. If \code{TRUE} the corresponding components of the fit
(the model frame, the model matrices , the response) are returned.}

\item{...}{further arguments passed to methods. See also \code{\link{zelig}}.}
}
\description{
Vignette: \url{http://docs.zeligproject.org/articles/zelig_ivreg.html}
}
\details{
Fit instrumental-variable regression by two-stage least squares. This is
equivalent to direct instrumental-variables estimation when the number of
instruments is equal to the number of predictors.

Regressors and instruments for \code{ivreg} are most easily specified in
a formula with two parts on the right-hand side, e.g.,
\code{y ~ x1 + x2 | z1 + z2 + z3}, where \code{x1} and \code{x2} are the regressors and
\code{z1}, \code{z2}, and \code{z3} are the instruments. Note that exogenous regressors
have to be included as instruments for themselves. For example, if there is
one exogenous regressor \code{ex} and one endogenous regressor \code{en} with
instrument \code{in}, the appropriate formula would be \code{y ~ ex + en | ex + in}.
Equivalently, this can be specified as \code{y ~ ex + en | . - en + in}, i.e.,
by providing an update formula with a \code{.} in the second part of the
formula. The latter is typically more convenient, if there is a large
number of exogenous regressors.
}
\section{Methods}{

\describe{
\item{\code{zelig(formula, data, model = NULL, ..., weights = NULL, by,
  bootstrap = FALSE)}}{The zelig function estimates a variety of statistical models}
}}

\examples{
library(AER) # for sandwich vcov
library(dplyr) # for the pipe operator \%>\%

# load and transform data
data("CigarettesSW")
CigarettesSW$rprice <- with(CigarettesSW, price/cpi)
CigarettesSW$rincome <- with(CigarettesSW, income/population/cpi)
CigarettesSW$tdiff <- with(CigarettesSW, (taxs - tax)/cpi)

# log second stage independent variables, as logging internally for ivreg is
# not currently supported
CigarettesSW$log_rprice <- log(CigarettesSW$rprice)
CigarettesSW$log_rincome <- log(CigarettesSW$rincome)

# estimate model
z.out1 <- zelig(log(packs) ~ log_rprice + log_rincome |
                    log_rincome + tdiff + I(tax/cpi),
                    data = CigarettesSW,
                    model = "ivreg")
summary(z.out1)
from_zelig_model(z.out1) \%>\% summary(vcov = sandwich, df = Inf,
                                     diagnostics = TRUE)
# simulate and plot quantities of interest
z.out1 \%>\% setx() \%>\% sim() \%>\% plot()

# ANOVA
z.out2 <- zelig(log(packs) ~ log_rprice |
                tdiff, data = CigarettesSW,
                model = "ivreg")
anova(from_zelig_model(z.out1), from_zelig_model(z.out2))

}
\seealso{
\code{\link{zelig}},
Greene, W. H. (1993) \emph{Econometric Analysis}, 2nd ed., Macmillan.
}
