% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zadoks.original.model.r
\name{zakoks.original.model}
\alias{zakoks.original.model}
\title{Classical SEIR model for plant diseases from Zadoks (1971)}
\source{
Script written from equation described in Zadoks, J.C. 1971. Systems Analysis and the Dynamics of Epidemics. Phytopathology. 61:441-598.
}
\usage{
zakoks.original.model(nlpd = 4 * 10, nipd = 1 * 10, dmfr = 16, SITE0 = 5
  * 10^9, weather, sdate = 145, ldate = 145 + 50, XLAT0 = 1)
}
\arguments{
\item{nlpd}{: latent period (in degree.day) - default value for Puccinia triticina : ~10 days at 20degC}

\item{nipd}{: infectious period (in degree.day) - default value for Puccinia triticina : ~20 days at 20degC}

\item{dmfr}{: daily multiplication factor - default value number of effective spores produced by lesion}

\item{SITE0}{:}

\item{weather}{: weather data.frame for one single year}

\item{sdate}{: starting date}

\item{ldate}{: ending date}

\item{XLAT0}{:}
}
\value{
list with a data.frame with daily day, DACE, XVAC, XLAT, XINF, XCTR ,XTO1, XSEV= XSEV, severity
and a vector of parameter value (nlpd, nipd, dmfr, SITE0).
}
\description{
\strong{Model description.}
This model is a classical SEIR model for plant disease. It was written from it description included in the original publication of Zadoks (1971)
}
\details{
This model is a classical SEIR model proposed by Zadoks (1971) to simulate epidemics of diseases of crops. It is a Susceptible-Exposed-Infectious-Removed (SEIR) model. This simple model of an epidemic is based on the epidemiological concepts "latent period", "infectious period", and "multiplication factor". The crop is considered to consist of a large but finite number of infectious sites. The physical dimensions of an infectious site roughly coincide with the reproductive unit of the parasite studied. Different pathosystems (with different infectious site definitions) can be considered with this model. A full description, is available in the original paper:
The model has four essential state variables representing the number of sites in each state
XVAC for vacant (healthy) sites, XLAT for latent site, XINF for infectant sites and XCTR for the cumulative total of removal (post infectious) sites.
Two supplementary variables based on the state variables are used defined as XTO1 = XLAT+XINF+XCTR and XSEV = XINF+XCTR.
Fluxes or rates between the state variables are defined as rocc for occupation, rapp for apparition and rrem for removal.
The model has a time step of one day (dt=1). The system modeled is one hectare of a wheat crop.
}
\examples{
weather=subset(weather_FranceWest, WEYR==1997 & idsite==39)
out=zakoks.original.model(nlpd=4*10,nipd=1*10,dmfr=16,SITE0 = 5*10^9,
weather, sdate = 145, ldate = 145+50 , XLAT0=1)
plot(out$sim$DACE,out$sim$severity, type="l")
}
\seealso{
\code{\link{epirice.model}}
}
