\name{zim}
\alias{zim}
\title{Fitting Zero-Inflated Models}
\usage{
zim(formula, data, subset, na.action, weights = 1, offset = 0,
  control = zim.control(...), ...)
}
\arguments{
  \item{formula}{an objective of class
  "\code{\link{formula}}".}

  \item{data}{an optional dataframe, list or environment
  containing the variables in the model.}

  \item{subset}{an optional vector specifying a subset of
  observations to be used in the fitting process.}

  \item{na.action}{a function which indicates what should
  happen when the data contain \code{NA}s.}

  \item{weights}{an optional vector of 'prior weights' to
  be used in the fitting process.}

  \item{offset}{this can be used to specify a priori known
  component to be included in the linear predictor during
  fitting.}

  \item{control}{control arguments.}

  \item{...}{additional arguments.}
}
\description{
\code{zim} is used to fit zero-inflated models.
}
\note{
\code{\link{zim}} is very similar to
\code{\link[pscl]{zeroinfl}} from the \code{pscl} package.
Both functions can be used to fit observation-driven models
for zero-inflated time series.
}
\seealso{
\code{\link{zim.fit}}, \code{\link{zim.control}}
}
\keyword{regression}

