\name{saveXML}
\alias{saveXML}
\alias{saveXML.XMLInternalDocument}
\alias{saveXML.XMLInternalDOM}
\alias{saveXML.XMLNode}
\alias{saveXML.XMLOutputStream}
\title{Output internal XML Tree}
\description{
  Methods for writing the representation of an XML tree to a string or
  file.
  Originally this was intended to be used only for
  DOMs (Document Object Models) stored in internal memory
  created via \code{\link{xmlTree}}, but methods for
  \code{XMLNode} and \code{XMLOutputStream} objects
  allow it to be generic for different representations of the
  XML tree.
}
\usage{
saveXML(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n', doctype = NULL)
saveXML.XMLInternalDocument(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n', doctype = NULL)
saveXML.XMLInternalDOM(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n', doctype = NULL)
saveXML.XMLNode(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n', doctype = NULL)
saveXML.XMLOutputStream(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n', doctype = NULL)
}
\arguments{
  \item{doc}{the document object representing the XML document.}
  \item{file}{the name of the file to which the contents of the XML
    nodes will be serialized.}
  \item{compression}{an integer value between 0 and 9 indicating the
    level of compression to use when saving the file. Higher values
    indicate increased compression and hence smaller files
    at the expense of computational time to do the compression and decompression.}
  \item{indent}{a logical value indicating whether to indent
    the nested nodes when serializing to the stream.}
  \item{prefix}{a string that is written to the stream/connection before
     the XML is output. If this is NULL, it is ignored. This allows us to
     put the XML introduction/preamble at the beginning of the document
     while allowing it to be omitted when we are outputting multiple
     "documents" within a single stream.}
  \item{doctype}{an object identifying the elements for the DOCTYPE in the output.
    This can be a string or an object of class \code{Doctype}.}
}
\details{
 One can create an internal XML tree (or DOM)
 using \code{\link{newXMLDoc}} and \code{\link{newXMLNode}}.
 \code{saveXML} allows one to generate a textual representation of
 that DOM in human-readable and reusable XML format.
 \code{saveXML} is a generic function that allows one to call
 the rendering operation with either the top-level node
 of the DOM or of the document object (of class \code{XMLInternalDocument}
 that is used to 
 accumulate the nodes and with which the developer 
 adds nodes.
}
\value{
 
}
\references{\url{http://www.w3.org/XML}, \url{http://www.omegahat.org/RSXML}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{newXMLDoc}}
\code{\link{newXMLNode}}
\code{\link{xmlOutputBuffer}}
\code{\link{xmlOutputDOM}}
}

\examples{
con <- xmlOutputDOM()
con$addTag("author", "Duncan Temple Lang")
con$addTag("address",  close=FALSE)
con$addTag("office", "2C-259")
con$addTag("street", "Mountain Avenue.")
con$addTag("phone", close=FALSE)
con$addTag("area", "908", attrs=c(state="NJ"))
con$addTag("number", "582-3217")
con$closeTag() # phone
con$closeTag() # address

saveXML(con$value(), file="out.xml")
}
\keyword{IO}
\keyword{file}

