% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGraphML2AA.r
\name{xGraphML2AA}
\alias{xGraphML2AA}
\title{Function to generate a graphml file from a pathway upon query}
\usage{
xGraphML2AA(
data = NULL,
org = c("human", "mouse"),
query = "AA:hsa04672",
curation = c("manual", "automatic", "any"),
node.label = "label",
node.color = "lfc",
colormap = "deepskyblue-lightyellow-darkorange",
ncolors = 64,
nlegend = 9,
zlim = NULL,
legend.title = "",
title.thispath = NULL,
node.tooltip = "tooltip",
node.highlight = "fdr",
node.highlight.cutoff = 0.05,
edge.color = "#00000033",
edge.width = 1,
color.gene = "#dddddd",
color.thispath = "#dddddd",
color.otherpath = "#eeeeee",
size.gene = 10,
size.gene.found = 11,
size.gene.highlight = 12,
filename = "xGraphML2AA",
verbose = TRUE,
RData.location = "http://galahad.well.ox.ac.uk/bigdata",
guid = NULL
)
}
\arguments{
\item{data}{a data frame}

\item{org}{a character specifying an organism. Currently supported
organisms are 'human' and 'mouse'}

\item{query}{the identity of a pathway in query. The full list of
pathways can be found at
\url{http://www.genome.jp/kegg-bin/show_organism?menu_type=pathway_maps&org=hsa}
for human and at
\url{http://www.genome.jp/kegg-bin/show_organism?menu_type=pathway_maps&org=mmu}
for mouse. For example, 'AA:hsa04672' for 'NOD-like receptor signaling
pathway', where the prefix 'AA:' can be ignored. Alternatively, it can
be key words describing the pathway}

\item{curation}{the type of curation. It can be one of "manual" (the
manual one 'AA' followed by the semi-manual one 'AT'), "automatic"
(only the automatic one) or "any" (first the manual one then the
automatic one)}

\item{node.label}{a character specifying which column used for node
labelling. By default, it is 'label'}

\item{node.color}{a character specifying which column used for node
coloring. By default, it is 'lfc'}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap),
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta), and "ggplot2" (emulating ggplot2
default color palette). Alternatively, any hyphen-separated HTML color
names, e.g. "lightyellow-orange" (by default), "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{ncolors}{the number of colors specified over the colormap}

\item{nlegend}{the number of colors specified in the legend. By
default, it is 11}

\item{zlim}{the minimum and maximum z/patttern values for which colors
should be plotted, defaulting to the range of the finite values of z.
Each of the given colors will be used to color an equispaced interval
of this range. The midpoints of the intervals cover the range, so that
values just outside the range will be plotted}

\item{legend.title}{the legend title. By default, it is ''}

\item{title.thispath}{the appended title for this pathway. By default,
it is NULL}

\item{node.tooltip}{a character specifying which column used for node
tooltip. By default, it is 'tooltip'. If not found, it will be
'Symbol-Name-Color'}

\item{node.highlight}{a character specifying which column used for node
highlighting. By default, it is 'fdr'. If so, those highlighted will
have bold and larger labels}

\item{node.highlight.cutoff}{a numeric specifying the cutoff for node
highlighting. By default, it is 0.05 meaninght those less than this
cutoff will be highlighted}

\item{edge.color}{a character specifying the edge colors. By default,
it is '#00000033'}

\item{edge.width}{the edge width. By default, it is 1}

\item{color.gene}{a character specifying the gene node colors. By
default, it is '#dddddd'}

\item{color.thispath}{a character specifying the color for this pathway
node. By default, it is '#dddddd'}

\item{color.otherpath}{a character specifying the color for other
pathway nodes. By default, it is '#eeeeee'}

\item{size.gene}{an integer character specifying the gene label
fontsize. By default, it is 10}

\item{size.gene.found}{an integer character specifying the label
fontsize for genes found/matched. By default, it is 11}

\item{size.gene.highlight}{an integer character specifying the label
fontsize for genes highlighted. By default, it is 12}

\item{filename}{the without-extension part of the name of the output
file. By default, it is 'xGraphML2AA'}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}

\item{guid}{a valid (5-character) Global Unique IDentifier for an OSF
project. See \code{\link{xRDataLoader}} for details}
}
\value{
invisible (a string storing graphml-formatted content). If the filename
is not NULL, a graphml-formatted file is also output.
}
\description{
\code{xGraphML2AA} is supposed to generate a graphml file from a
pathway upon query. If data is provided, pathway gene members are
color-coded.
}
\note{
none
}
\examples{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

\dontrun{
data(Haploid_regulators)
## IRF1 regulators
data <- subset(Haploid_regulators, Phenotype=='IRF1')

xGraphML2AA(query="AA:hsa04630", RData.location=RData.location,
color.gene='#dde8f1',size.gene=11)

## load GWAS genes
GWAS_Gene <- xRDataLoader(RData.customised='GWAS_Gene',
RData.location=RData.location)
data <- GWAS_Gene \%>\% filter(Odds_Ratio!='NULL',Disease_ID=='RA')
\%>\%
transmute(label=Symbol,lfc=log2(as.numeric(Odds_Ratio)),fdr=Pvalue)
\%>\% group_by(label) \%>\% summarise(lfc=max(lfc),fdr=min(fdr))

## manual one (the same as curation='any')
xGraphML2AA(data, query="AA:hsa04630", curation='manual',
node.label="label", node.color="lfc", node.highlight='fdr',
node.highlight.cutoff=5e-8, filename='xGraphML2AA',
legend.title='log2(Odds ratio)', zlim=c(-1,1),
RData.location=RData.location)
## automatic one
xGraphML2AA(data, query="AA:hsa04630", curation='automatic',
node.label="label", node.color="lfc", node.highlight='fdr',
node.highlight.cutoff=5e-8, filename='xGraphML2AA',
legend.title='log2(Odds ratio)', zlim=c(-1,1),
RData.location=RData.location)

## key words 
xGraphML2AA(data, query="Asthma", curation='any', node.label="label",
node.color="lfc", node.highlight='fdr', node.highlight.cutoff=5e-8,
filename='xGraphML2AA', RData.location=RData.location,
legend.title='log2(Odds ratio)', zlim=c(-1,1))
}
}
\seealso{
\code{\link{xGraphML2AA}}
}
