% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xLDsampling.r
\name{xLDsampling}
\alias{xLDsampling}
\title{Function to generate randomly sampled LD blocks}
\usage{
xLDsampling(bLD, GR.SNP = c("dbSNP_GWAS", "dbSNP_Common",
"dbSNP_Single"),
num.samples = 2000, respect = c("maf", "distance", "both"),
restrict.chr = F, preserve = c("boundary", "exact"), seed = 825,
verbose = T, RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{bLD}{a bLD object, containing a set of blocks based on which to
generate a null distribution}

\item{GR.SNP}{the genomic regions of SNPs. By default, it is
'dbSNP_GWAS', that is, SNPs from dbSNP (version 150) restricted to GWAS
SNPs and their LD SNPs (hg19). It can be 'dbSNP_Common', that is,
Common SNPs from dbSNP (version 150) plus GWAS SNPs and their LD SNPs
(hg19). Alternatively, the user can specify the customised GR object
directly}

\item{num.samples}{the number of samples randomly generated}

\item{respect}{how to respect the properties of to-be-sampled LD
blocks. It can be one of 'maf' (respecting the maf of the best SNP),
'distance' (respecting the distance of the best SNP to the nearest
gene), and 'both' (respecting the maf and distance)}

\item{restrict.chr}{logical to restrict to the same chromosome. By
default, it sets to false}

\item{preserve}{how to preserve the resulting null LD block. It can be
one of 'boundary' (preserving the boundary of the LD block), and
'exact' (exactly preserving the relative SNP locations within the LD
block). Notably, no huge difference for the boundary preserving when
enrichment analysis invovles region-based genomic annotations, but it
may make difference when genomic annatations are largely SNP-based
(such as eQTLs)}

\item{seed}{an integer specifying the seed}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a GRL object, each containing an GR oject storing an instance of
sampled blocks (with a meta-column 'best' for the identity, and a
meta-column 'B' for the instance sequence).
}
\description{
\code{xLDsampling} is supposed to generate randomly sampled LD blocks.
A sample block has the same boundary range as the observed, and can
respect maf of the best SNP, and/or distance of the best SNP to the
nearest gene. Also it can be restricted to the same chromosome. For
each null LD block, it can preserve the boundary only or exactly
preserve the relative SNP locations. It returns a GRL object.
}
\examples{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"

\dontrun{
# a) provide the seed SNPs with the significance info
## load ImmunoBase
data(ImmunoBase)
## get lead SNPs reported in AS GWAS and their significance info (p-values)
gr <- ImmunoBase$AS$variant
data <- GenomicRanges::mcols(gr)[,c('Variant','Pvalue')]

# b) get LD block (EUR population)
bLD <- xLDblock(data, include.LD="EUR", LD.r2=0.8,
RData.location=RData.location)

# c) generate random samples as a GRL object
grl <- xLDsampling(bLD, GR.SNP="dbSNP_GWAS", num.samples=2000,
RData.location=RData.location)

##########################
## Advanced use: customised GR.SNP
##########################
GR.SNP <- xRDataLoader("dbSNP_GWAS", RData.location=RData.location)
grl <- xLDsampling(bLD, GR.SNP=GR.SNP, respect="both", restrict.chr=T,
preserve="exact", RData.location=RData.location)
}
}
\seealso{
\code{\link{xLDsampling}}
}
