% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGRscores.r
\name{xGRscores}
\alias{xGRscores}
\title{Function to score genomic regions based on the given significance level}
\usage{
xGRscores(data, significance.threshold = 0.05, score.cap = 10,
verbose = T, RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{a named input vector containing the sinificance level for
genomic regions (GR). For this named vector, the element names are GR,
in the format of 'chrN:start-end', where N is either 1-22 or X, start
(or end) is genomic positional number; for example, 'chr1:13-20'. The
element values for the significance level (measured as p-value or fdr).
Alternatively, it can be a matrix or data frame with two columns: 1st
column for GR, 2nd column for the significance level.}

\item{significance.threshold}{the given significance threshold. By
default, it is set to NULL, meaning there is no constraint on the
significance level when transforming the significance level of GR into
scores. If given, those GR below this are considered significant and
thus scored positively. Instead, those above this are considered
insigificant and thus receive no score}

\item{score.cap}{the maximum score being capped. By default, it is set
to 10. If NULL, no capping is applied}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a data frame with following columns:
\itemize{
\item{\code{GR}: genomic regions}
\item{\code{Score}: the scores for GR calculated based on p-values
taking into account the given threshold of the significant level}
\item{\code{Pval}: the input p-values for GR}
}
}
\description{
\code{xGRscores} is supposed to score a list of genomic regions
together with the significance level.
}
\note{
None
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"

# a) provide the seed SNPs with the significance info
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get lead SNPs reported in AS GWAS and their significance info (p-values)
gr <- ImmunoBase$AS$variant
df <- as.data.frame(gr, row.names=NULL)
chr <- df$seqnames
start <- df$start
end <- df$end
sig <- df$Pvalue
GR <- paste(chr,':',start,'-',end, sep='')
data <- cbind(GR=GR, Sig=sig)

# b) calculate GR scores (considering significant cutoff 5e-5)
df_GR <- xGRscores(data=data, significance.threshold=5e-5,
RData.location=RData.location)
}
}
\seealso{
\code{\link{xRDataLoader}}
}

