% Generated by roxygen2 (4.0.2): do not edit by hand
\name{whitestripe_ind_to_mask}
\alias{whitemask}
\alias{whitestripe_ind_to_mask}
\title{WhiteStripe Indices to Mask}
\usage{
whitestripe_ind_to_mask(img, indices, writeimg = FALSE, ...)
}
\arguments{
\item{img}{Array or class nifti that is corresponds to dimensions of the images the
indices were generated from}

\item{indices}{indices from \code{\link{whitestripe}}}

\item{writeimg}{logical to write image or not}

\item{...}{arguments to passed to \code{\link{writeNIfTI}} for writing image}
}
\value{
Class of array or nifti depending on img input
}
\description{
Uses WhiteStripe indices to create image mask
}
\examples{
\dontrun{
if (download_img_data()){
t1 = readNIfTI(system.file("T1Strip.nii.gz", package="WhiteStripe"))
t2 = readNIfTI(system.file("T2Strip.nii.gz", package="WhiteStripe"))
ind = whitestripe_hybrid(t1, t2)
mask = whitestripe_ind_to_mask(t1, ind$whitestripe.ind)
orthographic(mask)
}
}
}
\seealso{
whitestripe, whitestripe_hybrid
}
\keyword{hybrid,}
\keyword{whitestripe}

