% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.weightit.R
\name{plot.weightit}
\alias{plot.weightit}
\title{Plot information about the weight estimation process}
\usage{
\method{plot}{weightit}(x, ...)
}
\arguments{
\item{x}{a \code{weightit} object; the output of
a call to \code{\link[=weightit]{weightit()}}.}

\item{...}{Unused.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{plot.weightit()} plots information about the weights depending on how they were estimated. Currently, only weighting using \code{method = "gbm"} is supported. To plot the distribution of weights, see \code{\link[=plot.summary.weightit]{plot.summary.weightit()}}.
}
\details{
\subsection{\code{method = "gbm"}}{

After weighting with generalized boosted modeling, \code{plot()} displays the results of the tuning process used to find the optimal number of trees (and tuning parameter values, if modified) that are used in the final weights. The plot produced has the number of trees on the x-axis and the value of the criterion on the y axis with a diamond at the optimal point. When multiple parameters are selected by tuning, a separate line is displayed on the plot for each combination of tuning parameters. When \code{by} is used in the call to \code{weightit()}, the plot is faceted by the \code{by} variable. See \code{\link{method_gbm}} for more information on selecting tuning parameters.
}
}
\examples{

# See example at the corresponding methods page

}
\seealso{
\code{\link[=weightit]{weightit()}}, \code{\link[=plot.summary.weightit]{plot.summary.weightit()}}
}
