% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.rmanova}
\alias{wp.rmanova}
\title{Statistical Power Analysis for Repeated Measures ANOVA}
\usage{
wp.rmanova(n = NULL, ng = NULL, nm = NULL, f = NULL, nscor = 1,
  alpha = 0.05, power = NULL, type = 0)
}
\arguments{
\item{n}{Sample size.}

\item{ng}{Number of groups.}

\item{nm}{Number of measurements.}

\item{f}{Effect size.
We use the statistic f as the measure of effect size for repeated-measures ANOVA as in \cite{Cohen(1988, p.275)}.}

\item{nscor}{Nonsphericity correction coefficient.
The nonsphericity correction coefficient is a measure of the degree of sphericity in the population.
A coefficient of 1 means sphericity is met, while a coefficient less than 1 means not met.
The samller value of the coefficient means the further departure from sphericity.
The lowest value of the coefficient is 1/(nm-1) where nm is the total number of measurements.
Two viable approaches for computing the empirical nonsphericity correction coefficient are sggested.
One is by \cite{Greenhouse and Geisser (1959)}, the other is by \cite{Huynh and Feldt (1976)}.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{power}{Statistical power.}

\item{type}{Type of analysis (\code{0} or \code{1} or \code{2}). The value "0" is for between-effect; "1" is for within-effect; and "2" is for interaction effect.}
}
\value{
An object of the power analysis
}
\description{
Repeated-measures ANOVA can be used to compare the means of a sequence of measurements (e.g., \cite{O'brien & Kaiser, 1985}). In a repeated-measures design, evey subject is exposed to all different treatments, or more commonly measured across different time points.
Power analysis for (1) the within-effect test about the mean difference among measurements by default.
If the subjects are from more than one group,the power analysis is also available for (2) the between-effect test about mean difference among groups and (3) the interaction effect test of the measurements and groups.
}
\examples{
#To calculate the statistical power for repeated-measures ANOVA:
wp.rmanova(n=30, ng=3, nm=4, f=0.36, nscor=0.7)
#  Repeated-measures ANOVA analysis
#
#    n    f ng nm nscor alpha     power
#    30 0.36  3  4   0.7  0.05 0.2674167
#
#  NOTE: Power analysis for between-effect test
#  URL: http://psychstat.org/rmanova

#To generate a power curve given a sequence of sample sizes:
res <- wp.rmanova(n=seq(30,150,20), ng=3, nm=4, f=0.36, nscor=0.7)
#  Repeated-measures ANOVA analysis
#
#      n    f ng nm nscor alpha     power
#     30 0.36  3  4   0.7  0.05 0.2674167
#     50 0.36  3  4   0.7  0.05 0.4386000
#     70 0.36  3  4   0.7  0.05 0.5894599
#     90 0.36  3  4   0.7  0.05 0.7110142
#    110 0.36  3  4   0.7  0.05 0.8029337
#    130 0.36  3  4   0.7  0.05 0.8691834
#    150 0.36  3  4   0.7  0.05 0.9151497
#
#  NOTE: Power analysis for between-effect test
#  URL: http://psychstat.org/rmanova

#To plot the power curve:
plot(res)

#To calculate the required sample size given power and effect size:
wp.rmanova(n=NULL, ng=3, nm=4, f=0.36, power=0.8, nscor=0.7)
#  Repeated-measures ANOVA analysis
#
#           n    f ng nm nscor alpha power
#    109.2546 0.36  3  4   0.7  0.05   0.8
#
#  NOTE: Power analysis for between-effect test
#  URL: http://psychstat.org/rmanova

#To calculate the minimum detectable effect size given power and sample size:
wp.rmanova(n=30, ng=3, nm=4, f=NULL, power=0.8, nscor=0.7)
#  Repeated-measures ANOVA analysis
#
#     n        f ng nm nscor alpha power
#    30 0.716768  3  4   0.7  0.05   0.8
#
#  NOTE: Power analysis for between-effect test
#  URL: http://psychstat.org/rmanova

# To generate a power curve given a sequence of effec sizes:
wp.rmanova(n=30, ng=3, nm=4, f=seq(0.1,0.5,0.05), nscor=0.7)
#  Repeated-measures ANOVA analysis
#
#     n    f ng nm nscor alpha      power
#    30 0.10  3  4   0.7  0.05 0.06442235
#    30 0.15  3  4   0.7  0.05 0.08327886
#    30 0.20  3  4   0.7  0.05 0.11101678
#    30 0.25  3  4   0.7  0.05 0.14853115
#    30 0.30  3  4   0.7  0.05 0.19640404
#    30 0.35  3  4   0.7  0.05 0.25460008
#    30 0.40  3  4   0.7  0.05 0.32223192
#    30 0.45  3  4   0.7  0.05 0.39746082
#    30 0.50  3  4   0.7  0.05 0.47757523
#
#  NOTE: Power analysis for between-effect test
#  URL: http://psychstat.org/rmanova
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed). Hillsdale, NJ: Lawrence Erlbaum Associates.

Greenhouse, S. W., & Geisser, S. (1959). On methods in the analysis of profile data. Psychometrika, 24(2), 95-112.

Huynh, H., & Feldt, L. S. (1976). Estimation of the Box correction for degrees of freedom from sample data in randomized block and split-plot designs. Journal of educational statistics, 1(1), 69-82.

O'brien, R. G., & Kaiser, M. K. (1985). MANOVA method for analyzing repeated measures designs: an extensive primer. Psychological bulletin, 97(2), 316.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
