% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DebugFn.R
\name{DebugPrintFn}
\alias{DebugPrintFn}
\title{Capture arguments of exception throwing plot for later debugging.}
\usage{
DebugPrintFn(saveFile, fn, ...)
}
\arguments{
\item{saveFile}{path to save RDS to.}

\item{fn}{function to call}

\item{...}{arguments for fn}
}
\value{
fn(...) normally, but if f(...) throws an exception save to saveFile RDS of list r such that do.call(r$fn,r$args) repeats the call to fn with args.
}
\description{
Run fn and print result, save arguments on failure.  Use on systems like ggplot()
where some calculation is delayed until print().
}
\examples{

d <- data.frame(x=1:5)
DebugPrintFn('problem.RDS','PlotDistCountNormal',d,xvar='x','example')
tryCatch(
   DebugPrintFn('problem.RDS','PlotDistCountNormal',
      d,xvar='xmisspelled','example'),
   error = function(e) { print(e) })

}

