\name{TrioWPCCurve}
\alias{TrioWPCCurve}

\title{Generate Three Weighted Predictiveness Curves in Graph}

\description{
This function will generate three weighted predictiveness curves in graph using the estimates provided by "npr.wpc.est" or "cox.wpc.est" functions.
It can be used to compare the relationships between survival rate and biomarker from three different curves. 

similarly, We can utilize this function to compare the performances from non-parametric predictiveness curves using three different sets of parameters,
or compare the predictiveness curves by using data from three different treatment groups and therefore compare treatment-by-biomarker relationships. 
}

\usage{
TrioWPCCurve(wpc1, wpc2, wpc3, xlab, ylab, main, ylim, xlim, type, col1, col2, col3, 
lwd, legendloc, legendtxt, confi, ptsest)
}

\arguments{
  \item{wpc1}{It is the object1 generated by function cox.wpc.est or npr.wpc.est.}
  \item{wpc2}{It is the object2 generated by function cox.wpc.est or npr.wpc.est.}
  \item{wpc3}{It is the object3 generated by function cox.wpc.est or npr.wpc.est.}
  \item{xlab}{It is the title for x axis; default is "Marker".}
  \item{ylab}{It is the title for y axis; default is "Survival Rate".}
  \item{main}{It is the title for the plot; default is "Weighted Predictiveness Curve".}
  \item{ylim}{It creates the continuous scale of y axis of the plot; default is "c(0,1)".}
  \item{xlim}{It creates the continuous scale of y axis of the plot; default is "c(0,100)".}
  \item{type}{It defines the type of the curves; default is "l".}
  \item{col1}{It defines the color of the curve 1 from object 1; default is "red".}
  \item{col2}{It defines the color of the curve 2 from object 2; default is "blue".}
  \item{col3}{It defines the color of the curve 3 from object 2; default is "black".}
  \item{lwd}{It defines the width of the curve; default is "2".}
  \item{legendloc}{It specifies the location of the legend; default is "bottomright".}
  \item{legendtxt}{It provides the text of the legend; default is "c("Method1")".}
  \item{confi}{It provides the option of drawing the confidence bands; default is "N", which means no confidence band is needed; "Y" will report the confidence band.}
  \item{ptsest}{It provides the option of drawing the point estimates; default is "N", which means no point estimates is needed; "Y" will report the point estimates.}
}


\references{ Yang H., Tang R., Hale M. and Huang J. (2016) A visualization method measuring the performance of biomarkers for guiding treatment decisions \emph{Pharmaceutical Statistics}, 15(\bold{2}), 1539-1612
}

\author{
Hui Yang \email{huiy@amgen.com}, Rui Tang \email{rui_tang@vrtx.com} and Jing Huang \email{jinghuang0@gmail.com}
}

\seealso{
\code{\link{SoloWPCCurve}}, \code{\link{DuoWPCCurve}}
}

\examples{
	tmppb = wpcdata[wpcdata$TRTA=="Placebo",]
	tmptrt1 = wpcdata[wpcdata$TRTA=="LowDose",]
	tmptrt2 = wpcdata[wpcdata$TRTA=="HighDose",]
	o.data1 =data.frame(event=tmppb$OSday, censor=tmppb$OScensor, marker=tmppb$Biomarker1)
	o.data2 =data.frame(event=tmptrt1$OSday, censor=tmptrt1$OScensor, marker=tmptrt1$Biomarker1)
	o.data3 =data.frame(event=tmptrt2$OSday, censor=tmptrt2$OScensor, marker=tmptrt2$Biomarker1)
	
	\dontrun{npr.object1 = npr.wpc.est(event=o.data1$event, censor=o.data1$censor, 
	marker=o.data1$marker,cutoff=180,method="window.width",weights="huber",
	wdth=10,sspeed=1, df=2, confi="YES", nbtsp=1000)
	npr.object2 = npr.wpc.est(event=o.data2$event, censor=o.data2$censor,
	marker=o.data2$marker,cutoff=180,method="window.width",weights="huber",
	wdth=10,sspeed=1, df=2, confi="YES", nbtsp=1000)
	npr.object3 = npr.wpc.est(event=o.data3$event, censor=o.data3$censor, 
	marker=o.data3$marker,cutoff=180,method="window.width",weights="huber",
	wdth=10,sspeed=1, df=2, confi="YES", nbtsp=1000)

	TrioWPCCurve(npr.object1,npr.object2,npr.object3,xlab="Marker",ylab="Survival Rate",
	main="Weighted Predictiveness Curve",ylim=c(0,1),xlim=c(0,100),type="l",col1="red",
	col2="blue",col3="black",lwd=2,legendloc="bottomright",legendtxt=c("Method1",
	"Method2","Method3"),confi="Y")}}



\keyword{WPC Graph}