% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{WH_1d_fixed_lambda}
\alias{WH_1d_fixed_lambda}
\title{Whittaker-Henderson Smoothing (Maximum Likelihood, fixed lambda)}
\usage{
WH_1d_fixed_lambda(
  d,
  ec,
  y,
  wt,
  lambda = 1000,
  q = 2,
  p,
  reg = FALSE,
  verbose = FALSE,
  accu_dev = 1e-12
)
}
\arguments{
\item{d}{Vector of observed events}

\item{ec}{Vector of central exposure}

\item{y}{Vector of observations}

\item{wt}{Optional vector of weights}

\item{lambda}{Smoothing parameter}

\item{q}{Order of penalization. Polynoms of degrees q - 1 are considered
smooth and are therefore unpenalized}

\item{p}{The number of eigenvectors to keep}

\item{reg}{Should the regression framework be used ? Boolean. If \code{TRUE}, will
stop after the first iteration.}

\item{accu_dev}{Tolerance for the convergence of the optimization procedure}
}
\value{
An object of class \code{"WH_1d"} i.e. a list containing model fit,
variance, residuals and degrees of freedom as well as diagnosis to asses
the quality of the fit.
}
\description{
Whittaker-Henderson Smoothing (Maximum Likelihood, fixed lambda)
}
\keyword{internal}
