% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{WH_2d_perf}
\alias{WH_2d_perf}
\title{2D Whittaker-Henderson Smoothing (Maximum Likelihood, Generalized Fellner-Schall update)}
\usage{
WH_2d_perf(
  d,
  ec,
  y,
  wt,
  q = c(2, 2),
  p,
  criterion = "REML",
  lambda = c(1000, 1000),
  reg = FALSE,
  verbose = FALSE,
  accu_crit = 1e-12,
  accu_dev = 1e-12
)
}
\arguments{
\item{d}{Vector of observed events}

\item{ec}{Vector of central exposure}

\item{y}{Vector of observations}

\item{wt}{Optional vector of weights}

\item{q}{Order of penalization. Polynoms of degrees q - 1 are considered
smooth and are therefore unpenalized}

\item{p}{The number of eigenvectors to keep}

\item{criterion}{Criterion used to choose the smoothing parameter. One of
"GCV" (default), "AIC" or "BIC".}

\item{lambda}{Initial smoothing parameters}

\item{reg}{Should the regression framework be used ? Boolean. If \code{TRUE}, will
stop after the first iteration.}

\item{verbose}{Should information about the optimization progress be
displayed}

\item{accu_crit}{Tolerance for the convergence of the outer optimization
procedure}

\item{accu_dev}{Tolerance for the convergence of the optimization procedure}
}
\value{
An object of class \code{"WH_2d"} i.e. a list containing model fit,
variance, residuals and degrees of freedom as well as diagnosis to asses
the quality of the fit.
}
\description{
2D Whittaker-Henderson Smoothing (Maximum Likelihood, Generalized Fellner-Schall update)
}
\keyword{internal}
