% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hydro_data.R
\name{get_hydro_data}
\alias{get_hydro_data}
\title{Get hydrological data}
\usage{
get_hydro_data(lon, lat, path_dem_raster = NULL, path_output)
}
\arguments{
\item{lon}{A numeric vector giving the longitude of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitude of the sampling sites in Decimal Degrees.}

\item{path_dem_raster}{The file path to a Digital Elevation Model (DEM) raster. See \code{download_elevation_data}
for methods to download DEM raster data. If NULL, a DEM is downloaded automatically using this function.}

\item{path_output}{The file path of an output directory where spatial data will be saved.}
}
\value{
data.frame
}
\description{
This function takes information of where and when a set of environmental samples were
collected and retrieves a suite of topographical and hydrological variables for each unique
location. The variables include: elevation, slope, aspect, Topographical Wetness Index (TWI),
flow accumulation, total flow accumulation within 500m, and distance to the nearest stream.
If a DEM is not provided, then a DEM is acquired via \href{https://www.rdocumentation.org/packages/elevatr/versions/0.99.0/topics/get_elev_raster}{\code{elevatr::get_elev_raster}}
and the suite of variables are calculated using functions from the \href{https://CRAN.R-project.org/package=whitebox}{'WhiteboxTools'}
R frontend.
}
\examples{
\donttest{

MCO_lon <- c(7.416, 7.434)
MCO_lat <- c(43.734, 43.747)

download_elevation_data(lon = MCO_lon,
                        lat = MCO_lat,
                        path_output = tempdir())

get_hydro_data(lon = MCO_lon,
               lat = MCO_lat,
               path_dem_raster = file.path(tempdir(), 'dem.tif'),
               path_output = tempdir())

}
}
