% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsGLM.R
\name{walsGLMfit}
\alias{walsGLMfit}
\title{Fitter function for Weighted Average Least Squares estimation of GLMs}
\usage{
walsGLMfit(X1, X2, y, betaStart1, betaStart2, family, prior = weibull(), ...)
}
\arguments{
\item{X1}{Design matrix for focus regressors. Usually includes a constant
(column full of 1s) and can be generated using model.matrix().}

\item{X2}{Design matrix for auxiliary regressors. Usually does not include
a constant column and can also be generated using model.matrix().}

\item{y}{Response as vector.}

\item{betaStart1}{Starting values for coefficients of focus regressors X1.}

\item{betaStart2}{Starting values for coefficients of auxiliary regressors X2.}

\item{family}{Object of class \code{"\link[WALS]{familyWALS}"}.}

\item{prior}{Object of class \code{"\link[WALS]{familyPrior}"}. For example
\code{\link[WALS]{weibull}} or \code{\link[WALS]{laplace}}.}

\item{...}{Further arguments passed to \code{\link[WALS]{walsFit}}.}
}
\value{
A list containing all elements returned by \code{\link[WALS]{walsFit}},
except for \code{residuals}, and additionally (some fields are replaced)
\item{condition}{Condition number of the matrix
\eqn{\bar{\Xi} = \bar{\Delta}_{2} \bar{X}_{2}^{\top} \bar{M}_{1} \bar{X}_{2} \bar{\Delta}_{2}}.}
\item{family}{Object of class \code{"\link[WALS]{familyWALS}"}. The family used.}
\item{betaStart}{Starting values of the regression coefficients for the
one-step ML estimators.}
\item{fitted.link}{Linear link fitted to the data.}
\item{fitted.values}{Estimated conditional mean for the data. Lives on the
scale of the response.}
}
\description{
Workhorse function behind \code{\link[WALS]{walsGLM}} and used internally in
\code{\link[WALS]{walsGLMfitIterate}}.
}
\details{
Uses \code{\link[WALS]{walsFit}} under the hood after transforming the regressors
\code{X1} and \code{X2} and the response \code{y}. For more details, see
\insertCite{huynhwals}{WALS} and \insertCite{deluca2018glm;textual}{WALS}.
}
\examples{
data("HMDA", package = "AER")
X <- model.matrix(deny ~ pirat + hirat + lvrat + chist + mhist + phist + selfemp + afam,
                  data = HMDA)
X1 <- X[,c("(Intercept)", "pirat", "hirat", "lvrat", "chist2", "chist3",
        "chist4", "chist5", "chist6", "mhist2", "mhist3", "mhist4", "phistyes")]
X2 <- X[,c("selfempyes", "afamyes")]
y <- HMDA$deny

# starting values from glm.fit()
betaStart <- glm.fit(X, y, family = binomialWALS())$coefficients
k1 <- ncol(X1)
k2 <- ncol(X2)

str(walsGLMfit(X1, X2, y,
               betaStart1 = betaStart[1:k1],
               betaStart2 = betaStart[(k1 + 1):(k1 + k2)],
               family = binomialWALS(), prior = weibull()))


}
\references{
\insertAllCited{}
}
\seealso{
\link{walsGLM}, \link{walsGLMfitIterate}, \link{walsFit}.
}
