% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-utils.R
\name{interactivePlots}
\alias{interactivePlots}
\title{function that generates interactive plots of the package downloads logs from CRAN}
\usage{
interactivePlots(
  downloads.data,
  mytitle = paste(downloads.data$package[1], "Package downloads counts"),
  nbrPlts = 2,
  month.ln = 30,
  HTMLfile = paste0("Interactive_DWNLDS_", downloads.data$package[1], ".html"),
  device = "HTML",
  dirSave = NULL
)
}
\arguments{
\item{downloads.data}{total downloads from the package}

\item{mytitle}{optional char argument specifying the title to be displayed}

\item{nbrPlts}{optional numeric argument specifying number of plots to generate}

\item{month.ln}{optional numeric argument specifying the lenght of the month in days}

\item{HTMLfile}{an optional string argument specifying the name of the file where to save the plots}

\item{device}{an optional string describing whether the interactive plot will be set to screen or to save in an HTLM file}

\item{dirSave}{specify a valid directory where to save the plot}
}
\description{
function that generates interactive plots of the package downloads logs from CRAN
}
\examples{
\dontrun{
packageXdownloads <- retrievePckgData("ggplot")[[1]]
interactivePlots(packageXdownloads)
}

}
