% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-utils.R
\name{staticPlots}
\alias{staticPlots}
\title{function that generates visual trends of the package downloads logs from CRAN, it will generate 4 plots: two histograms, a pulse plot and the main plot is a plot of the downloads as a function of time}
\usage{
staticPlots(
  pckg.stats.total,
  device = "PDF",
  fileName = paste0("DWNLDS_", pckg.stats.total$package[1], ".", tolower(device)),
  dirSave = NULL,
  combinePlts = FALSE,
  noMovAvg = FALSE,
  noConfBands = FALSE,
  cutOff.pts = 250,
  dbg = FALSE
)
}
\arguments{
\item{pckg.stats.total}{total downloads from the package}

\item{device}{string to select the output format: 'PDF'/'PNG'/'JPEG' or 'screen'}

\item{fileName}{an optional string argument specifying the name of the file where to save the plots}

\item{dirSave}{specify a valid directory where to save the plot}

\item{combinePlts}{a boolean indicating whether the plots generated will be combined into one single figure or not}

\item{noMovAvg}{a boolean indicating whether moving statistical estimators, such as, the moving average will be displayed}

\item{noConfBands}{a boolean indicating whether a confidence band will be displayed}

\item{cutOff.pts}{an integer value indicating the cut-off value to determine whether there would be a subsample for clarity sake in the plots}

\item{dbg}{internal flag for activating debugging options, i.e. display furhter information in screen}
}
\description{
function that generates visual trends of the package downloads logs from CRAN, it will generate 4 plots: two histograms, a pulse plot and the main plot is a plot of the downloads as a function of time
}
\examples{
\donttest{
packageData <- retrievePckgData("ggplot2")
totalDownloads <- packageData[[1]]
#lastmonthDownloads <- packageData[[2]]
staticPlots(totalDownloads, device="screen")
staticPlots(totalDownloads,combinePlts=TRUE, device="screen")
}

}
