% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_visitation_model.R
\name{check_arguments}
\alias{check_arguments}
\title{Check Arguments}
\usage{
check_arguments(
  popularity_proxy,
  onsite_usage,
  constant,
  omit_trend,
  trend,
  ref_series,
  is_input_logged,
  ...
)
}
\arguments{
\item{popularity_proxy}{A vector which stores a time series which may be used as a proxy for the monthly popularity of social media over time. The length of \code{popularity_proxy} must be the same as that of \code{onsite_usage}. The default option is NULL, in which case, no proxy needs to be supplied. Note that this vector cannot have a value of 0.}

\item{onsite_usage}{A vector which stores monthly on-site usage for a particular social media platform and recreational site.}

\item{constant}{A numeric specifying the constant term (beta0) in the model. This constant is understood as the mean log adjusted monthly visitation relative to the base month. The default option is 0, implying that the (logged) \code{onsite_usage} does not require any constant shift, which is unusual. If \code{ref_series} is supplied, the constant is overwritten by the least squares estimate.}

\item{omit_trend}{This is obsolete and is left only for compatibility. In other words, \code{trend} will overwrite any option chosen in \code{omit_trend}. If \code{trend} is NULL, then \code{trend} is overwritten according to \code{omit_trend}. It is a Boolean specifying whether or not to consider the trend component to be 0. The default option is TRUE, in which case, the trend component is 0. If it is set to FALSE, then it is estimated using data.}

\item{trend}{A character string specifying how the trend is modeled. Can be any of NULL, "linear", "none", and "estimated", where "none" and "estimated" correspond to \code{omit_trend} being TRUE and FALSE, respectively. If NULL, then it follows the value specified in \code{omit_trend}.}

\item{ref_series}{A numeric vector specifying the original visitation series. The default option is NULL, implying that no such series is available. If such series is available, then its length must be the same as that of \code{onsite_usage}.}

\item{is_input_logged}{A boolean specifying if the input is logged or not}

\item{...}{Additional arguments.}
}
\value{
No return value, called for extra information.
}
\description{
Check arguments.
}
