% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClaytonGumbelCopula.R
\name{surClaytonCopula}
\alias{surClaytonCopula}
\alias{r90ClaytonCopula}
\alias{r270ClaytonCopula}
\title{Survival and Rotated Clayton Copulas}
\usage{
surClaytonCopula(param = 1)
}
\arguments{
\item{param}{A single parameter defining the Copula.}
}
\value{
An object of class \code{\linkS4class{surClaytonCopula}},
\code{\linkS4class{r90ClaytonCopula}} or
\code{\linkS4class{r270ClaytonCopula}} respectively.
}
\description{
These are wrappers to functions from \code{\link{VineCopula-package}}
}
\examples{

library(copula)

persp(surClaytonCopula(1.5), dCopula, zlim = c(0,10))
persp(r90ClaytonCopula(-1.5), dCopula, zlim = c(0,10))
persp(r270ClaytonCopula(-1.5), dCopula, zlim = c(0,10))

}
\author{
Benedikt Graeler
}
\keyword{copula}
