% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateLD.R
\name{simulateLD}
\alias{simulateLD}
\title{Simulate a dataset for testing the performance of screenlong}
\usage{
simulateLD(n = 100, J = 10, rho = 0.6, p = 500, trueIdx = c(5, 100,
  200, 400), beta0Fun = NULL, betaFun = NULL, gammaFun = NULL,
  varFun = NULL)
}
\arguments{
\item{n}{Number of subjects in the simulated dataset}

\item{J}{Number of observations per subject}

\item{rho}{The correlation parameter for the AR-1 correlation structure.}

\item{p}{The total number of features to be screened from}

\item{trueIdx}{The indexes for the active features in the simulated x matrix.
This should be a vector, and the values should be a subset of 1:p.}

\item{beta0Fun}{The time-varying intercept for the data-generating model, as a function of
time.  If left as null, it will default to \code{f(t) 2 * t^2 - 1}. Time is assumed to be scaled
to the interval [0,1].}

\item{betaFun}{The time-varying coefficients for z in the data-generating model, as a
function of time.  If left as null, it will be specified as two functions. The first is
\code{f(t) exp(t + 1)/2}. The second is \code{f(t) t^2 + 0.5}. Time is assumed
to be scaled to the interval [0,1].}

\item{gammaFun}{A list of functions of time, one function for each entry in trueIdx,
giving the time-varying effects of each active feature in the simulated x matrix.
If left as null, it will be specified as four functions.  The first is a step function
\code{f(t)=(t > 0.4)}.  The second is \code{f(t)=- cos(2 * pi * t)}.  the third is \code{f(t)=(2 - 3 * t)^2/2 - 1}.
The fourth is \code{f(t)=sin(2 * pi * t)}.}

\item{varFun}{A function of time telling the marginal variance of the error function at a
given time.  If left as null, it will be specified as \code{function(t) 0.5 + 3 * t^3}.}
}
\value{
A list with following components:
     x Matrix of features to be screened.  It will have n*J rows and p columns.
     y Vector of responses.  It will have length of n*J.
     z A matrix representing covariates to be included in each of the screening models.
       The first column will be all ones, representing the intercept.  The second will
       consist of random ones and zeros, representing simulated genders.
     id Vector of integers identifying the subject to which each observation belongs.
     time Vector of real numbers identifying observation times. It should have the same
          length as the number of rows of x.
}
\description{
Simulates a dataset that can be used to test the screenlong function,
and to test the performance of the proposed method under different scenarios.
The simulated dataset has two z-covariates and p x-covariates, only a
few of which have nonzero effect.  There are n subjects in the simulated
dataset, each having J observations, which are not necessarily evenly timed,
we randomly draw a subset to create an unbalanced dataset. The within-subject
correlation is assumed to be AR-1.
}
\examples{
set.seed(12345678)
results <- simulateLD(p=1000)
}

