% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.VFP}
\alias{predict.VFP}
\title{Predict Method for Objects of Class 'VFP'.}
\usage{
\method{predict}{VFP}(
  object,
  model.no = NULL,
  newdata = NULL,
  alpha = 0.05,
  dispersion = NULL,
  type = c("vc", "sd", "cv"),
  CI.method = c("chisq", "t", "normal"),
  use.log = FALSE,
  ...
)
}
\arguments{
\item{object}{(object) of class "VFP"}

\item{model.no}{(integer) specifying a fitted model stored in 'object'}

\item{newdata}{(numeric) optionally, a vector specifying mean-values for which predictions
on the user-defined scale ('type') are requested. If omitted, fitted values 
will be returned.}

\item{alpha}{(numeric) value specifying the 100 x (1-alpha)\% confidence interval of predicted
values}

\item{dispersion}{(numeric) NULL = the dispersion will be set =1 (should usually not be changed; 
For the Saddler model, the dispersion is 1.),
    numeric value = the dispersion parameter will be used as specified}

\item{type}{(character) specifying on which scale the predicted values shall be returned, 
possible are "vc" = variance, "sd"=standard deviation, "cv"=coefficient of variation}

\item{CI.method}{(character) one of "t", "normal", "chisq" specifying which CI-method to use}

\item{use.log}{(logical) TRUE = X- and Y-axis will be log-transformed}

\item{...}{additional parameters passed forward to function \code{\link[gnm]{predict.gnm}}}
}
\value{
(data.frame) with numeric variables:\cr
			\item{Mean}{value at which predictions were requested}
			\item{Fitted}{prediction at 'Mean'}
		\item{SE}{standard error of prediction}
			\item{Scale}{residual scale}
			\item{LCL}{lower confidence limit of the 100x(1-'alpha')\% CI}
 		\item{UCL}{upper confidence limit of the 100x(1-'alpha')\% CI}
}
\description{
Predictions are made for the variance (type="vc"), standard deviation ("sd") or 
coefficient of variation ("cv") and their corresponding confidence intervals.
The latter are calculated primarily on the variance scale and then transformed to the
other scales, if required.
}
\examples{
\donttest{
library(VCA)
data(VCAdata1)
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
mat <- get_mat(lst)		# automatically selects "total"
res <- fit_vfp(model.no=1:9, Data=mat)
predict(res)
predict(res, dispersion=0.95)
}
}
