% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{Scale}
\alias{Scale}
\title{Automatically Scale Data Calling These Functions: 'anovaVCA', 'anovaMM', 'remlVCA' or 'remlMM'.}
\usage{
Scale(Fun, form, Data, ...)
}
\arguments{
\item{Fun}{(expr, function, character) either a complete function call to one of "anovaVCA", "anovaMM", "remlVCA", "remlMM",
a character string or just the function name without quotes (see example)}

\item{form}{(formula) specifying the model to fitted by 'Fun'}

\item{Data}{(data.frame) with all variables specified via 'Fun'}

\item{...}{additional arguments applying to one of the four functions \code{\link{anovaVCA}},\code{\link{anovaMM}},
\code{\link{remlVCA}}, \code{\link{remlMM}}}
}
\value{
(object) of class 'VCA' which can be used as input for function \code{\link{VCAinference}}
}
\description{
This function scales data before fitting a linear mixed model aiming to avoid numerical problems
when numbers of the response variable are either very small or very large. It adds attribute "scale" 
to the resulting 'VCA'-object, which is used by function \code{\link{reScale}} to transform back the
VCA-results of a \code{VCA} or \code{VCAinference} object that was previously scaled.
}
\details{
NOTE: Scaling is applied on the complete data set, without checking whether there are incomplete
observations or not!
}
\examples{
\dontrun{
data(dataEP05A2_3)

# simulate very large numbers of the response
dat3   <- dataEP05A2_3
dat3$y <- dat3$y * 1e8

# now try to fit 21-day model to this data
fit <- anovaVCA(y~day/run, dat3)

# now use 'Scale' function
fit1 <- Scale("anovaVCA", y~day/run, dat3)
fit2 <- Scale(anovaVCA, y~day/run, dat3)	# also works
fit3 <- Scale(anovaVCA(y~day/run, dat3)) # works as well

# back to original scale
(fit1 <- reScale(fit1))
(fit2 <- reScale(fit2))
(fit3 <- reScale(fit3))

# reference values
fit0 <- anovaVCA(y~day/run, dataEP05A2_3, MME=TRUE)
inf0 <- VCAinference(fit0, VarVC=TRUE)

fit1 <- Scale(anovaVCA(y~day/run, dataEP05A2_3, MME=TRUE))
inf1 <- VCAinference(fit1, VarVC=TRUE)
inf1 <- reScale(inf1)

# compare to reference
print(inf0, what="VC")
print(inf1, what="VC")
print(inf0, what="SD")
print(inf1, what="SD")
print(inf0, what="CV")
print(inf1, what="CV")

# now use REML-based estimation
fit0 <- remlVCA(y~day/run, dataEP05A2_3)
inf0 <- VCAinference(fit0)

fit1 <- Scale("remlVCA", y~day/run, dataEP05A2_3)
inf1 <- VCAinference(fit1)
inf1 <- reScale(inf1)

# compare to reference
print(inf0, what="VC")
print(inf1, what="VC")
print(inf0, what="SD")
print(inf1, what="SD")
print(inf0, what="CV")
print(inf1, what="CV")

# scaling also works with by-processing
data(VCAdata1)
fit <- Scale(anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample"))
reScale(fit)
}
}
\seealso{
\code{\link{reScale}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
