% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlCvrt.R
\name{dl2vbt}
\alias{dl2vbt}
\title{Convert a double list to vector binary tree}
\usage{
dl2vbt(x, regularize = TRUE, splt = "-")
}
\arguments{
\item{x}{A double list to be converted.}

\item{regularize}{A boolean value to control the treatment of empty layers of double listed to be converted.
The default value \code{TRUE} will fill the empty layer by mark "*". The default value is recommanded.}

\item{splt}{A string pattern to split the binding elements in each layer if the sub-constructure exists.
The default pattern uses "-".}
}
\value{
Return a vector binary tree.
}
\description{
Convert a double list to vector binary tree. The pure numeric layers will be sorted intrinsically then
all elements be exported in character form.
}
\examples{
#Structurize the column names of datatest:
colname <- colnames(datatest)
colnamedl <- chrvec2dl(colname, "-")
colnamevbt <- dl2vbt(colnamedl)

#Simple data cleaning for sub-constructure existing double list;
#Make unregulated double list:
unregdl <- list(c("7", 2, 10), c("chr", "5"), c(),
c("var2", "var1", "var3"), c("M-8-9", "3-2"), c("6-3", "2-7"))
regvbt <- dl2vbt(unregdl)
regvbt2 <- dl2vbt(unregdl, FALSE) # not recommended
}
\seealso{
\code{\link[VBTree:vbtinq]{vbtinq}}, \code{\link[VBTree:vbtsub]{vbtsub}}, \code{\link[VBTree:advbtinq]{advbtinq}},
\code{\link[VBTree:advbtsub]{advbtsub}}, \code{\link[VBTree:trvssubinq]{trvssubinq}}, \code{\link[VBTree:dl2ts]{dl2ts}},
\code{\link[VBTree:dl2arr]{dl2arr}}.
}
\keyword{Double.List}
\keyword{Vector.Binary.Tree}
