% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrCvrt.R
\name{arr2vbt}
\alias{arr2vbt}
\title{Convert a structured character array to double list}
\usage{
arr2vbt(x, ...)
}
\arguments{
\item{x}{A structured character array to be converted.}

\item{...}{Argument in \code{\link[VBTree:chrvec2dl]{chrvec2dl}} to control split pattern.}
}
\value{
Return a vector binary tree based on the input array.
}
\description{
Convert a structured character array to a vector binary tree. All character elements in array will be splited by
a specific pattern then sorted intrinsically in each layer of the vector binary tree.
}
\examples{
#Write the column names of datatest into a array:
arr <- dl2arr(chrvec2dl(colnames(datatest)))

#Recover the vector binary tree from character array:
arr2vbt(arr)
}
\seealso{
\code{\link[VBTree:arr2dl]{arr2dl}}, \code{\link[VBTree:chrvec2dl]{chrvec2dl}}.
}
\keyword{Vector.Binary.Tree}
\keyword{array}
