% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{hausdorff_check}
\alias{hausdorff_check}
\title{Function for Hausdorff distance computation}
\usage{
hausdorff_check(pts.final, brk)
}
\arguments{
\item{pts.final}{a list of estimated change points}

\item{brk}{the true change points}
}
\value{
Hausdorff distance summary results, including mean, standard deviation and median.
}
\description{
The function includes two Hausdorff distance.
The first one is hausdorff_true_est (\eqn{d(A_n, \tilde{A}_n^f)}): for each estimated change point, we find the closest true CP and compute the distance, then take the maximum of distances.
The second one is hausdorff_est_true(\eqn{d(\tilde{A}_n^f, A_n)}): for each true change point, find the closest estimated change point and compute the distance, then take the maximum of distances.
}
\examples{
## an example of 10 replicates result
set.seed(1)
nob <- 1000
brk <- c(333, 666, nob+1)
cp.list <- vector('list', 10)
for(i in 1:10){
    cp.list[[i]] <-  brk[1:2] + sample(c(-50:50),1)
}
# some replicate fails to detect all the change point
cp.list[[2]] <- cp.list[[2]][1]
cp.list[4] <- list(NULL)      # setting 4'th element to NULL.
# some replicate overestimate the number of change point
cp.list[[3]] <- c(cp.list[[3]], 800)
cp.list
res <- hausdorff_check(cp.list, brk)
res

}
