% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{summary.VARDetect.simu.result}
\alias{summary.VARDetect.simu.result}
\title{A function to summarize the results for simulation}
\usage{
\method{summary}{VARDetect.simu.result}(object, critical = 5, ...)
}
\arguments{
\item{object}{A S3 object of class \code{VARDetect.simu.result}}

\item{critical}{A positive integer, set as the critical value defined in selection rate, to control the range of success, default is 5}

\item{...}{not in use}
}
\value{
A series of summary, including the selection rate, Hausdorff distance, and statistical measurments, running times
}
\description{
A function to summarize the results for simulation class \code{VARDetect.simu.result}
}
\examples{
\donttest{
nob <- 4000; p <- 15
brk <- c(floor(nob / 3), floor(2 * nob / 3), nob + 1)
m <- length(brk); q.t <- 1
sp_density <- rep(0.05, m * q.t)
signals <- c(-0.6, 0.6, -0.6)
try_simu <- simu_tbss(nreps = 3, simu_method = "sparse", nob = nob, 
                      k = p, lags = q.t, brk = brk, sigma = diag(p), 
                      signals = signals, sp_density = sp_density, 
                      sp_pattern = "random", est_method = "sparse", 
                      q = q.t, refit = TRUE)
summary(try_simu, critical = 5)
}
}
