% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertID.R
\name{ConvertID}
\alias{ConvertID}
\title{Connect and parse UniProt database identifiers information.}
\usage{
ConvertID(ProteinAccList , ID_from = "UniProtKB_AC-ID" , ID_to = NULL
 , directorypath = NULL)
}
\arguments{
\item{ProteinAccList}{Vector of UniProt Accession/s}

\item{ID_from}{string of database identifier abbreviation, from which the Accession/ID will be converted}

\item{ID_to}{string of database identifier abbreviation, to which the Accession/ID will be converted.
default is all database identifier available in UniProtKB}

\item{directorypath}{path to save excel file containig results returened by the function.}
}
\value{
DataFrame where column one contains the Accession/ID before conversion
     and other columns contains the Accession/ID after conversion
}
\description{
The function is work to convert the UniProtKB AC/ID to any database identifiers
available by the UniProtKB.
For more information about available database identifiers
see https://www.uniprot.org/help/id_mapping.
see https://raw.githubusercontent.com/MohmedSoudy/UniprotR/master/uniprot_ids.csv
}
\note{
The function also, Creates a csv file with the retrieved information.
}
\author{
Mohmed Soudy \email{Mohamed.soudy@57357.com} and Ali Mostafa \email{ali.mo.anwar@std.agr.cu.edu.eg}
}
