% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbmom1.R
\name{uM3}
\alias{uM3}
\title{Unbiased central moment estimates}
\usage{
uM3(m3, n)
}
\arguments{
\item{m3}{naive biased third central moment estimate \eqn{m_3 = 1/n \sum_{i =
1}^n ((X_i - \bar{X})^3}{m[3] = mean((X - X-bar)^3)} for a vector \code{X}.}

\item{n}{sample size.}
}
\value{
Unbiased estimate of a third central moment.
}
\description{
Calculate unbiased estimates of central moments and their powers and
products.
}
\examples{
n <- 10
smp <- rgamma(n, shape = 3)
m <- mean(smp)
for (j in 2:3) {
  m <- c(m, mean((smp - m[1])^j))
}
uM3(m[3], n)
}
\seealso{
Other unbiased estimates (one-sample): \code{\link{uM2M3}},
  \code{\link{uM2M4}}, \code{\link{uM2pow2}},
  \code{\link{uM2pow3}}, \code{\link{uM2}},
  \code{\link{uM3pow2}}, \code{\link{uM4}},
  \code{\link{uM5}}, \code{\link{uM6}}
}
\concept{unbiased estimates (one-sample)}
