\name{LocalFunction}
\alias{LocalFunction}
\title{Generate a LocalFunction object for Umacs Sampler function}
\description{
Generates an object that is used to define a \emph{local} R function
in a sampler function generated by \code{\link{Sampler}}.

Usually a call to this function is not necessary,
since \code{LocalFunction} is implicitly done when the value of a \emph{named}
parameter in the argument list of \code{\link{Sampler}} is an R function.

}
\usage{
LocalFunction(x)
}
\arguments{
  \item{x}{ An R function }
}
\details{
\code{LocalFunction} is to be used only within the \code{Sampler} function call;
the value of the argument (\code{x}) is made available (locally)
in a sampling function that is built using the Umacs function \code{Sampler}.

The name of the parameter that will have the value (\code{x}) is \emph{not}
specified as an argument, but only within the \code{\link{Sampler}} function call.

}
\value{
An object of class \code{LocalFunction},
to be further processed by the Umacs function \code{\link{Sampler}}.

}
\references{Kerman, Jouni. Umacs: A Universal Markov Chain Sampler. Technical report, Columbia University, New York.}
\author{Jouni Kerman <jouni@kerman.com>}
\note{
A call to \code{LocalFunction} must be associated with a parameter name.

Components of vector parameters specified to be \code{LocalFunction}s cannot be updated,
but those specified to be \code{Data} can be updated.

To insert `raw code' in the iteration loop, use the function \code{\link{RawCode}}.
}
\seealso{
\code{\link{Umacs-package}} for an overview of the Umacs package.

\code{\link{Sampler}} for how to create a sampler function; see the vignette for details.

Package `rv'.

}
\examples{}
\keyword{iteration}
