% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/us_boundaries.R
\name{us_boundaries}
\alias{us_boundaries}
\title{Get the boundaries of the United States for a particular date}
\usage{
us_boundaries(map_date, type = c("state", "county"), format = c("sp", "df"),
  states)
}
\arguments{
\item{map_date}{The date of the map as an object of class \code{POSIXct},
\code{POSIXt}, or \code{Date}. For state maps the date must be between 3
September 1783 and 31 December 2000; for county maps the date must be
between 30 December 1636 and 31 December 2000.}

\item{type}{The type of the map, either \code{"state"} or \code{"county"}.}

\item{format}{The class of the object returned, either \code{"sp"} or
\code{"df"}, a fortified data frame.}

\item{states}{A character vector of state or territory names.}
}
\value{
A \code{sp} object or a data frame suitable for plotting.
}
\description{
This function returns
}
\examples{
map_states   <- us_boundaries(as.Date("1850-07-04"))
map_counties <- us_boundaries(as.Date("1850-07-04"), type = "county")
new_england <- c("Massachusetts", "Vermont", "New Hampshire", "Connecticut",
                 "Rhode Island", "Maine")
map_ne <- us_boundaries(as.Date("1943-02-12"), states = new_england)
if(require(sp)) {
  plot(map_states)
  plot(map_ne)
}
}

