% Generated by roxygen2 (4.0.2): do not edit by hand
\name{performCuts}
\alias{performCuts}
\title{Perform cuts in the data}
\usage{
performCuts(originalData)
}
\arguments{
\item{originalData}{a data frame to use as the baseline}
}
\value{
A data frame.
}
\description{
\code{performCuts} will perform cuts in the data. This function is provided
as a place holder, and it is empty, but it is called by \code{UPMASK}, so if the user
needs to perform cuts in the data for the UPMASK analysis, this function should be
tailored.
}
\examples{
# Create a simple data set with the values and errors
toyDataDF <- data.frame(x=runif(10, 0, 10), dx=rep(0.2, 10), y=runif(10, 0, 10),
                        dy=rep(0.1, 10))

# Call the function to perform cuts
newToyDataDF <- performCuts(toyDataDF)

# Clean the environment
rm(list=c("toyDataDF", "newToyDataDF"))
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{utilities}

