% Generated by roxygen2 (4.0.2): do not edit by hand
\name{create_randomKde2d}
\alias{create_randomKde2d}
\title{Compute the density based distance quantity using a 2D Kernel Density Estimation}
\usage{
create_randomKde2d(nstars, maxX, maxY, nKde=50, printPlots=FALSE,
showStats=FALSE, returnDistance=FALSE)
}
\arguments{
\item{nstars}{an integer with the number of stars to consider}

\item{maxX}{the length of the field in X}

\item{maxY}{the length of the field in Y}

\item{nKde}{the number of samplings of the kernel in each direction}

\item{printPlots}{a boolean indicating if the user wants to see plots}

\item{showStats}{a boolean indicating if the user wants to see statistics}

\item{returnDistance}{a boolean indicating if the user wants statistics to be returned}
}
\value{
A double representing the density based distance quantity.
}
\description{
\code{create_randomKde2d} will compute the 2D Kernel Density Estimation for
a random sampling of the requested number of points and will return the quantiy
\code{(max(d)-mean(d))/sd(d)}, if the option \code{returnDistance} is set to TRUE.
}
\examples{
# Compute the density based distance quantity with random fields
distVar <- create_randomKde2d(100, 10, 10, showStats=FALSE,
                              printPlots=FALSE, returnDistance=TRUE)

# Clean the environment
rm(distVar)
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\references{
\href{http://dx.doi.org/10.1051/0004-6361/201321143}{Krone-Martins, A. & Moitinho, A., A&A, v.561, p.A57, 2014}
}
\keyword{utilities}

