% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT.R
\name{plot.UPG.MNL}
\alias{plot.UPG.MNL}
\title{Coefficient plots for UPG.MNL objects}
\usage{
\method{plot}{UPG.MNL}(
  x = NULL,
  ...,
  sort = FALSE,
  names = NULL,
  groups = NULL,
  xlab = NULL,
  ylab = NULL,
  q = c(0.025, 0.975),
  include = NULL
)
}
\arguments{
\item{x}{an object of class \code{UPG.MNL}.}

\item{...}{other plot parameters.}

\item{sort}{a logical variable indicating whether the plotted coefficients should be sorted according to average effect sizes across groups. Default is FALSE.}

\item{names}{a character vector indicating names for the variables used in the plots.}

\item{groups}{a character vector indicating names for the groups excluding the baseline. The group names must correspond to the ordering in the dependent variable used for estimation.}

\item{xlab}{a character vector of length 1 indicating a title for the x-axis.}

\item{ylab}{a character vector of length 1 indicating a title for the y-axis.}

\item{q}{a numerical vector of length two providing the posterior quantiles to be extracted. Default are 0.025 and 0.975 quantiles.}

\item{include}{can be used to plot only a subset of variables. Specify the columns of X that should be kept in the plot. See examples for further information.}
}
\value{
Returns a ggplot2 object.
}
\description{
\code{plot} generates plots from \code{UPG.MNL} objects using \code{ggplot2}. Coefficient plots show point estimates for all coefficients in all groups except the baseline as well as their credible intervals.
}
\examples{
\donttest{
# estimate a multinomial logit model using example data
library(UPG)
data(program)
y = program[,1]
X = program[,-1]
results.mnl = UPG(y = y, X = X, model = "mnl")

# plot the results and sort coefficients by average effect size
plot(results.mnl, sort = TRUE)

# plot only variables 1 and 3 with custom group and variable names
# also, customize credible intervals and axis labels
plot(results.mnl,
     include  = c(1,3),
     names    = c("Custom 1", "Custom 2"),
     groups   = c("Alpha", "Beta"),
     q        = c(0.1, 0.9),
     xlab     = c("Custom X"),
     ylab     = c("Custom Y"))
}
}
\seealso{
\code{\link{summary.UPG.MNL}} to summarize a \code{UPG.MNL} object and create tables.
\code{\link{predict.UPG.MNL}} to predict probabilities using a \code{UPG.MNL} object.
\code{\link{coef.UPG.MNL}} to extract coefficients from a \code{UPG.MNL} object.
}
\author{
Gregor Zens
}
