% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{POTt}
\alias{POTt}
\title{Peaks over threshold (POT) data extraction (quick)}
\usage{
POTt(
  x,
  threshold = 0.975,
  div,
  Plot = TRUE,
  PlotType = "l",
  main = "Peaks over threhsold",
  ylab = "Magnitude",
  xlab = "Time"
)
}
\arguments{
\item{x}{either a numeric vector or dataframe with date (or POSIXct) in the first column and hydrological variable in the second}

\item{threshold}{user chosen threshold. Default is 0.975}

\item{div}{number of time steps between peaks to ensure independence.}

\item{Plot}{logical argument with a default of TRUE. When TRUE, the full hydrograph with the peaks over the threshold highlighted is plotted}

\item{PlotType}{Type of plot with a default of "l" for line graph. For rainfall type "h" for bars could be used.}

\item{main}{Title for the plot. Default is "Peaks over threshold"}

\item{ylab}{Label (character) for the plot y axis. Default is "Magnitude"}

\item{xlab}{Label (character) for the plot x axis. Default is "Time".}
}
\value{
A data.frame with columns; Date and peak, with the option of a plot. Or a numeric vector of peaks is returned if only a numeric vector of the variable is input as x.
}
\description{
Extracts independent peaks over a threshold from a sample, using time as the independence criteria.
}
\details{
This provides a quicker option than the POTextract function - useful for very long time series'. It only has the option of time division to ensure independence between peaks.
 If the x argument is a numeric vector, the peaks will be extracted with no time information.
 x can instead be a data.frame with dates in the first column and the numeric vector in the second.
 In this latter case, the peaks will be time-stamped and a hydrograph, including POT, will be plotted by default.
}
\examples{
#Extract POT data from Thames catchment daily rainfall 2000-10-01 to 2015-09-30 with
#div = 14 (14 days) and threshold = 0.975. Then display the first six rows
ThamesPPOT <- POTt(ThamesPQ[, c(1,2)], div = 14)
head(ThamesPPOT)
#Extract Thames rainfall POT from only the numeric vector of rainfall, with threshold
#set to 0.95 and div set to 14. Then display the first six rows
ThamesPPOT <- POTt(ThamesPQ[, 2], threshold = 0.95, div = 14)
head(ThamesPPOT)
}
\author{
Anthony Hammond
}
