% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenParetoPOT}
\alias{GenParetoPOT}
\title{Generalised Pareto distribution - estimates directly from sample}
\usage{
GenParetoPOT(x, ppy = 1, RP = 100, q = NULL)
}
\arguments{
\item{x}{numeric vector (block maxima sample)}

\item{ppy}{peaks per year}

\item{RP}{return period (default = 100)}

\item{q}{quantile (magnitude of variable)}
}
\value{
quantile as a function of RP or vice versa
}
\description{
Estimated quantiles as function of return period (RP) and vice versa, directly from the data
}
\details{
If the argument q is used, it overrides RP and provides RP as a function of q (magnitude of variable) as opposed to q as a function of RP. The average number of peaks per year argument (ppy) is for the function to convert from the peaks over threshold (POT) scale to the annual scale. For example, if there are 3 peaks per year, the probability associated with the 100-yr return period estimate would be 0.01/3 (i.e. an RP of 300 on the POT scale) rather than 0.01. The parameters are estimated by the method of L-moments, as detailed in 'Hosking J. Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-moments. Cambridge University Press, New York'.
}
\examples{
#Get a POT series and estimate the 50-year RP
ThamesPOT <- POTextract(ThamesPQ[,c(1,3)], thresh = 0.90)
GenParetoPOT(ThamesPOT$peak, ppy = 1.867, RP = 50)
#Estimate the RP for a 600m3/s discharge
GenParetoPOT(ThamesPOT$peak, ppy = 1.867, q = 600)
}
\author{
Anthony Hammond
}
