% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{ERPlot}
\alias{ERPlot}
\title{Extreme rank plot}
\usage{
ERPlot(x, dist = "GenLog", main = NULL, Pars = NULL, GF = NULL)
}
\arguments{
\item{x}{numeric vector. A sample for inspection}

\item{dist}{a choice of distribution. The choices are "GenLog" (the default), "GEV", "Kappa3,"Gumbel", and "GenPareto"}

\item{main}{a character string to change the default title, which is the distribution choice.}

\item{Pars}{a vector of parameters for the distribution. In the order of location, scale, & shape (ignoring the latter if Gumbel). If left null the parameters are estimated from x.}

\item{GF}{a vector of length growth curve parameters, in the order of; Lcv, LSkew and Median (ignoring the LSkew if Gumbel).}
}
\value{
The extreme rank plot as described in the details
}
\description{
A plot to inspect the distribution of ordered data
}
\details{
This plot compares the simulated flows for each rank of the sample with the observed flows of the same rank. 500 simulated flows for each rank are plotted and the mean of these is highlighted in red. There is a line of perfect fit so you can see how much this "cloud" of simulation differs from the observed.
By default the parameters of the distribution for comparison with the sample are estimated from the sample. However, the pars argument can be used to compare the distribution with parameters estimated separately. Similarly the growth factor (GF) parameters, linear coefficient of variation (Lcv) & linear skewness (LSkew) with the median can be entered. In this way the pooling estimated distribution can be compared to the sample. This ERplot is an updated version of that described in Hammond, A. (2019). Proposal of the ‘extreme rank plot’ for extreme value analysis: with an emphasis on flood frequency studies. Hydrology Research, 50 (6), 1495–1507.
}
\examples{
#Get an AMAX sample and plot
\donttest{AM.27083 <- GetAM(27083)}
\donttest{ERPlot(AM.27083$Flow)}
#Get a pooled estimate of Lcv & LSkew to use with the GF argument
\donttest{QuickResults(GetCDs(27083), gauged = TRUE)}
#Use the resulting Lcv, Lskew and RP2 for the GF argument and change the title
\donttest{ERPlot(AM.27083$Flow, main = "Site 27083 pooled comparison", GF = c(0.23, 0.17, 12))}
}
\author{
Anthony Hammond
}
