% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{Zdists}
\alias{Zdists}
\title{Zdist Goodness of fit measure for pooling groups}
\usage{
Zdists(x)
}
\arguments{
\item{x}{pooling group derived from the Pool() function}
}
\value{
A list with the first element a data.frame of three GoF scores related to the columns; "GEV" & "GenLog". The second element is a character stating which has the best fit.
}
\description{
Calculates the goodness of fit score for pooling groups.
}
\details{
The goodness of fit measure is detailed in "Improving the FEH statistical procedures for flood frequency estimation", Environment Agency (2008, ISBN: 978 1 84432 920 5).
}
\examples{
#Get CDs, form a pooling group and calculate the Zdist
CDs.203018 <- GetCDs(203018)
Pool.203018 <- Pool(CDs.203018)
Zdists(Pool.203018)
}
\author{
Anthony Hammond
}
