% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{OptimPars}
\alias{OptimPars}
\title{Optimise distribution parameters}
\usage{
OptimPars(x, dist = "GenLog")
}
\arguments{
\item{x}{a data.frame with RPs in the first column and associated estimates in the second column}

\item{dist}{a choice of distribution for the estimates. The choices are "GenLog" or "GEV" the generalised logistic and the generalised extreme value distribution, respectively. The default is "GenLog"}
}
\value{
The location, scale and shape parameters for the generalised logistic or Generalised extreme value distribution.
}
\description{
Estimates the parameters of the generalised extreme value or generalised logistic distribution from known return period estimates
}
\details{
Given a dataframe with return periods (RPs) in the first column and associated estimates in the second column, this function provides an estimate of the distribution parameters. Ideally the first RP should be 2. Extrapolation outside the RPs used for calibration comes with greater uncertainty.
}
\examples{
#Get some catchment descriptors and some quick results. Then estmate the GenLog parameters
Results <- QuickResults(GetCDs(96001))[[1]]
OptimPars(Results[,1:2])

}
\author{
Anthony Hammond
}
