% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{PoolEst}
\alias{PoolEst}
\title{Pooled flood estimates}
\usage{
PoolEst(
  x,
  gauged = FALSE,
  QMED,
  dist = "GenLog",
  RP = c(2, 5, 10, 20, 50, 75, 100, 200, 500, 1000),
  UrbAdj = FALSE,
  CDs = NULL,
  URBEXT = NULL,
  trend = FALSE
)
}
\arguments{
\item{x}{pooling group derived from the Pool function}

\item{gauged}{logical argument with a default of FALSE. TRUE for gauged results and FALSE for ungauged}

\item{QMED}{estimate of the median annual maximum flow}

\item{dist}{a choice of distribution for the estimates. The choices are "GenLog" or "GEV"; the generalised logistic and the generalised extreme value distribution, respectively. The default is "GenLog"}

\item{RP}{return period of interest. By default the following RPs are provided: 2, 5, 10, 20, 50, 75, 100, 200, 500, 1000}

\item{UrbAdj}{logical argument with a default of FALSE. When TRUE, an urban adjustment is applied to the pooled Lcv and LSkew}

\item{CDs}{catchment descriptors derived from either GetCDs or ImportCDs}

\item{URBEXT}{the catchment URBEXT2000, to be supplied if UrbAdj is TRUE and if CDs have not been}

\item{trend}{logical argument with a default of FALSE. TRUE adjusts the stationary QMED estimate to a non-stationary estimate}
}
\value{
A list of length two. Element one is a data frame with columns; return period (RP), peak flow estimates (Q) and growth factor estimates (GF). The second element is the estimated Lcv and Lskew.
}
\description{
Provides pooled results from a pooling group - gauged, ungauged and with urban adjustment if necessary.
}
\details{
PoolEst is a function to provide results from a pooling group derived using the Pool function. QMED (median annual maximum flow) needs to be supplied and can be derived from the QMED function for ungauged estimates or the annual maximum sample for gauged estimates. If the catchment of interest is urban, the UrbAdj argument can be set to TRUE. If this is done, either URBEXT (urban extent) needs to be provided or the catchment descriptors, derived from ImportCDs or GetCDs. The methods for estimating pooled growth curves are according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation. The methods for estimating the L-moments and growth factors are outlined in the Flood Estimation Handbook (1999), volume 3. When UrbAdj = TRUE, urban adjustment is applied to the QMED estimate according to the method outlined in the guidance by Wallingford HydroSolutions: 'WINFAP 4 Urban Adjustment Procedures'. If trend = TRUE & gauged = FALSE, the QMED is multiplied by a trend coefficient. The coefficient was derived by calculating a weighted (by sample size) mean proportional change in the 2-year flow, from the UK National River Flow Archive benchmark sites considered suitable for pooling. The weighted per year change was first calculated and then multiplied by half the mean sample size of sites suitable for QMED. If trend = TRUE and gauged = TRUE, the weighted per year change is multiplied by half the sample size of the first site in the pooling group. This approach attempts to include a generic non-stationarity in the pooled estimates by adjusting the location parameter. Amongst other assumptions (such as the change being linear and only to the location of the distribution), it makes the assumption that apparent trends at individual sites are unreliable due to short record lengths or site specific due to human influence, but across many sites the mean increase in median peak discharge is representative of a non-stationary process across the UK. The trend is applied to whatever is in the QMED argument. Therefore, trend should equal FALSE if the QMED estimate has been user adjusted for trend already. If Lcv & Lskew have also been user adjusted for a gauged site, these can be changed in the pooling group (see Pool function details). The per year, weighted mean QMED trend, was estimated to be 0.12 percent +/- 0.05 (95 percent uncertainty - calculated by weighted resampling).
}
\examples{
#Get some catchment descriptors and form a pooling group. It's urban and
#therefore the site of interest is not included.
CDs.27083 <- GetCDs(27083)
Pool.27083 <- Pool(CDs.27083)
#Get results for the ungauged case, with urban adjustment
PoolEst(Pool.27083, QMED = 11.941, UrbAdj = TRUE, CDs = CDs.27083)
#Form the group again with the urban gauge included & undertake a gauged estimate
#with urban adjustment. QMED in this example is estimated as the median of the annual
#maximum series for site 27083.
PoolG.27083 <- PoolG.27083 <- Pool(CDs.27083, iug = TRUE, DeUrb = TRUE)
PoolEst(PoolG.27083, QMED = 12.5, UrbAdj = TRUE, CDs = CDs.27083)

}
\author{
Anthony Hammond
}
