% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{H2}
\alias{H2}
\title{Heterogeneity measure (H2) for pooling groups.}
\usage{
H2(x)
}
\arguments{
\item{x}{pooling group derived from the Pool() function}
}
\value{
A vector of two characters; the first representing the H2 score and the second stating a qualitative measure of heterogeneity.
}
\description{
Quantifies the heterogeneity of a pooled group
}
\details{
The H2 measure was developed by Hosking & Wallis and can be found in their book 'Regional Frequency Analysis: an approach based on LMoments (1997). It was also adopted for use by the Flood Estimation Handbook (1999) and is described in volume 3.
}
\examples{
#Get CDs, form a pooling group and calculate H2
CDs.203018 <- GetCDs(203018)
Pool.203018 <- Pool(CDs.203018)
H2(Pool.203018)
}
\author{
Anthony Hammond
}
