% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_gene_tmb_cor}
\alias{vis_gene_tmb_cor}
\title{Visualize Correlation between Gene and TMB (Tumor Mutation Burden)}
\usage{
vis_gene_tmb_cor(
  Gene = "TP53",
  cor_method = "spearman",
  data_type = "mRNA",
  Plot = "TRUE"
)
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{cor_method}{correlation method}

\item{data_type}{choose gene profile type,
including "mRNA", "transcript", "protein", "mutation", "cnv" (-2, -1, 0, 1, 2),
"cnv_gistic2", "methylation", "miRNA".}

\item{Plot}{output the plot directly, default 'TRUE'}
}
\description{
Visualize Correlation between Gene and TMB (Tumor Mutation Burden)
}
\examples{
\dontrun{
p <- vis_gene_tmb_cor(Gene = "TP53")
}
}
