% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptrunc.R
\name{ptrunc}
\alias{ptrunc}
\alias{ptruncnorm}
\alias{ptruncbeta}
\alias{ptruncbinom}
\alias{ptruncpois}
\alias{ptruncchisq}
\alias{ptrunccontbern}
\alias{ptruncexp}
\alias{ptruncgamma}
\alias{ptruncinvgamma}
\alias{ptruncinvgauss}
\alias{ptrunclnorm}
\alias{ptruncnbinom}
\title{Cumulative Distribution Function}
\usage{
ptrunc(q, family, ..., lower.tail = TRUE, log.p = FALSE)

ptruncnorm(
  q,
  mean = 0,
  sd = 1,
  a = -Inf,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

ptruncbeta(
  q,
  shape1,
  shape2,
  a = 0,
  b = 1,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

ptruncbinom(
  q,
  size,
  prob,
  a = 0,
  b = size,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

ptruncpois(q, lambda, a = 0, b = Inf, ..., lower.tail = TRUE, log.p = FALSE)

ptruncchisq(q, df, a = 0, b = Inf, ..., lower.tail = TRUE, log.p = FALSE)

ptrunccontbern(q, lambda, a = 0, b = 1, ...)

ptruncexp(q, rate = 1, a = 0, b = Inf, ..., lower.tail = TRUE, log.p = FALSE)

ptruncgamma(
  q,
  shape,
  rate = 1,
  scale = 1/rate,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

ptruncinvgamma(
  q,
  shape,
  rate = 1,
  scale = 1/rate,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

ptruncinvgauss(q, m, s, a = 0, b = Inf, ...)

ptrunclnorm(
  q,
  meanlog = 0,
  sdlog = 1,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

ptruncnbinom(
  q,
  size,
  prob,
  mu,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{q}{vector of quantiles}

\item{family}{distribution family to use}

\item{...}{\emph{named} distribution parameters and/or truncation limits
(\code{a}, \code{b})}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are
\eqn{P(X <= x)}{P(X \leq x)} otherwise, \eqn{P(X > x)}}

\item{log.p}{logical; if \code{TRUE}, probabilities p are given as \code{log(p)}}

\item{mean}{mean of parent distribution}

\item{sd}{standard deviation is parent distribution}

\item{a}{point of left truncation. For discrete distributions, \code{a} will be
included in the support of the truncated distribution.}

\item{b}{point of right truncation}

\item{shape1}{positive shape parameter alpha}

\item{shape2}{positive shape parameter beta}

\item{size}{target for number of successful trials,
or dispersion parameter (the shape parameter of the gamma mixing
distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success on each trial}

\item{lambda}{mean and var of "parent" distribution}

\item{df}{degrees of freedom for "parent" distribution}

\item{rate}{inverse gamma rate parameter}

\item{shape}{inverse gamma shape parameter}

\item{scale}{inverse gamma scale parameter}

\item{m}{vector of means}

\item{s}{vector of dispersion parameters}

\item{meanlog}{mean of untruncated distribution}

\item{sdlog}{standard deviation of untruncated distribution}

\item{mu}{alternative parametrization via mean}
}
\value{
The cumulative probability of y.
}
\description{
Calculates the cumulative probability for a given truncated
distribution
}
\examples{
ptrunc(0)
ptrunc(6, family = "gaussian", mean = 5, sd = 10, b = 7)
pnorm(6, mean = 5, sd = 10) # for comparison
}
