% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{case_control_sampling_trials}
\alias{case_control_sampling_trials}
\title{Case-control sampling from extended data}
\usage{
case_control_sampling_trials(
  data_prep,
  p_control = NULL,
  subset_condition,
  sort = FALSE
)
}
\arguments{
\item{data_prep}{Result from \code{\link[=data_preparation]{data_preparation()}}.}

\item{p_control}{Proportion of controls to select at each follow-up time of each trial.}

\item{subset_condition}{Expression used to \code{\link[=subset]{subset()}} the trial data before sampling.}

\item{sort}{Sort data before sampling. This ensures results are identical between data prepared with
\code{separate_files} TRUE and FALSE.}
}
\value{
A \code{data.frame} or a \code{\link[=split]{split()}} \code{data.frame} if  \code{length(p_control) > 1}. An additional column
containing sample weights will be added to the result. These can be included in the models fit with
\code{\link[=trial_msm]{trial_msm()}}.
}
\description{
Case-control sampling from extended data
}
\examples{
# If necessary reduce the number of threads for data.table
data.table::setDTthreads(2)

data("te_data_ex")
samples <- case_control_sampling_trials(te_data_ex, p_control = 0.01)
}
