% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLSWlacf.R
\name{TLSWlacf}
\alias{TLSWlacf}
\title{Compute Localised Autocovariance Estimate of a TLSW Object}
\usage{
TLSWlacf(x.TLSW, lag.max = NULL)
}
\arguments{
\item{x.TLSW}{a \code{TLSW} object.}

\item{lag.max}{The maximum lag of acf required. If NULL then the same
default as in the regular acf function is used.}
}
\value{
An object of class \code{lacf} which contains the following components:
 \itemize{
 \item \code{lacf}: a matrix containing the estimate of the local autocovariance. Columns represent lags
 (beginning at lag 0), and rows represent time points.
\item \code{lacr}: a matrix containing the estimate of the local autocorrelation. Columns represent lags
(beginning at lag 0), and rows represent time points.
\item \code{name}: the name of the time series (if applicable).
\item \code{date}: the date the function was executed.
\item \code{SmoothWP}: The smoothed, un-corrected raw
wavelet periodogram of the input data.
\item \code{S}: the spectral estimate used to compute the local autocovariance.
\item \code{J}: the number of total wavelet scales.
}
}
\description{
Computes the local autocovariance and autocorrelation estimates, given an
input of an object of class TLSW containing the estimated spectrum. Provides the same functionality as the
function \code{lacf} from the \code{locits} package, but user provides an object of
class \code{TLSW} as the main argument.
}
\examples{

## ---- computes estimate of local autocovariance function


spec <- matrix(0, nrow = 9, ncol = 512)
spec[2, ] <- 1 + sin(seq(from = 0, to = 2 * pi, length = 512))^2

trend <- seq(from = 0, to = 10, length = 512)

set.seed(123)

x <- TLSWsim(trend = trend, spec = spec)

## ---- first estimate the spectrum:

x.TLSW <- TLSW(x)

#---- estimate the lacf:

lacf.est <- TLSWlacf(x.TLSW)

#---- plot the variance (lag 0 lacf) over time:

plot.ts(lacf.est$lacf[, 1], ylab = "Variance")
}
\references{
McGonigle, E. T., Killick, R., and Nunes, M. (2022). Trend
locally stationary wavelet processes. \emph{Journal of Time Series
Analysis}, 43(6), 895-917.

Nason, G. P. (2013). A test for second-order stationarity and approximate
confidence intervals for localized autocovariances for locally stationary
time series. \emph{Journal of the Royal Statistical Society: Series B
(Statistical Methodology)}, \bold{75(5)}, 879--904.

Nason, G. P. (2016). locits: Tests of stationarity and localized autocovariance.
R package version 1.7.3.
}
\seealso{
\code{\link[locits]{lacf}}
}
